;; missd9.lsp
;; Copyright (c) 1998 by Pedro Valero (valerop@uv.es)
;; Reporting multiple imputation datasets
;;  
;; 
;;########################################################################

(defmeth missing-data-model-object-proto :descriptives-mi (&key (print t))
  (let* (
         (print print)
         (list-datasets (send self :multiple-imputed-datasets-list))
         (list-data-matrix (mapcar #'(lambda (obj) (column-list (send obj :data-matrix)))
                                   list-datasets))
         (num-datasets (length (send self :multiple-imputed-datasets-list)))
         (num-variables (length (send self :variables)))
         (ncase (array-dimension (send (first (send self :multiple-imputed-datasets-list)) :data-matrix) 0))
   
         (variables (send self :variables))
         (labels (combine (mapcar #'(lambda (var) (combine var (repeat '"" (- num-datasets 1)))) variables)))
         (descriptives
          (mapcar #'(lambda (num-var) 
                      (mapcar #'(lambda (data-matrix) 
                                  (let ((var (select data-matrix num-var))
                                        )
                                    (list (mean var)
                                          (median var)
                                          (standard-deviation var)
                                          (skewness var)
                                          (kurtosis var)
                                          (min var)
                                          (max var))
                                    ))
                              list-data-matrix)
                      )
                  (iseq num-variables)))
         (wind (report-header "Descriptives Multiple Imputation" :page t))
         (display-string 
           (format nil "~%~%~%~%~%Descriptive statistics for Multiple Imputation~%") wind)
         (mat (make-array (list  (* num-variables num-datasets) 7) :initial-contents (combine descriptives)))
         )
   (when print 
         (pv-print-matrix-to-window mat wind 
                                    :decimals 3 
                                    :row-labels labels :column-labels 
                                    '("Mean" "Median" "Sd." "Skew." "Kurt." "Min." "Max.")
                                    :row-heading "Vars"
                                    :column-heading "")
     (display-string (format nil "~%") wind)
      (send wind :top-most t)
      (send wind :fit-window-to-text))
    descriptives))
      
 (defmeth missing-data-model-object-proto :combine-multiple-imputed-univariate-inferences ()
   (let* (
     (descrp (send self :descriptive-statistics-multiple-imputed-datasets))
          (numdatasets (length descrp))
     (pt-estimate (mapcar (lambda (var-desc)
                            (mean var-desc))
                          (first descrp)))
     (wtvar (mapcar (lambda (var-desc)
                            (mean var-desc))
                          (second descrp)))
     (btvar (mapcar (lambda (var-desc)
                            (variance var-desc))
                          (first descrp)))
     (totvar (mapcar (lambda (wt-var bt-var)
                            (+ wt-var (* (1+ (/ 1 numdatasets)) bt-var)))
                         wtvar btvar))
     (degfreedom (mapcar 
                  (lambda (wtvar btvar)
                          (if (> btvar 0)
                              (* (1- numdatasets) (** (1+ (/ wtvar (* 
                                                                    (1+ (/ 1 numdatasets))
                                                                    btvar)
                                                              )) 2))
                              0))
                  wtvar btvar))
    
          (interval-estimate (mapcar 
                              (lambda (degfreedom totvar pt-estimate)
                                (if (> degfreedom 0)
                                   (list
                                    (- pt-estimate
                                     (* (t-cdf .975 degfreedom) (sqrt totvar)))
                                    (+ pt-estimate 
                                       (* (t-cdf .975 degfreedom) (sqrt totvar))))
                                    (list pt-estimate))
                                )
                              
                              degfreedom totvar pt-estimate))
          )
     
     

     (list pt-estimate wtvar btvar totvar degfreedom interval-estimate)
     ))
                            
 (defmeth missing-data-model-object-proto :print-multiple-imputed ()
   (let*
     (
     (desc-multiple-imputed (send self ::combine-multiple-imputed-univariate-inferences))
     (variables (send self :variables))
      (numvariables (length variables))
      )

     (display-string   
               (format nil "~%~0a ~14a ~8a ~8a ~8a ~8a ~8a ~8a"
                       "" "Variables" "Mean  " "WT Var" "BT Var" "To Var" "DegFre" "IntEst"))

     (dotimes (i numvariables)
              
              (display-string   
               (format nil "~%~0a ~12a"
                       "" (select variables i) ))
             (mapcar (lambda (x)
                       (display-string   
               (format nil " ~8,2f" x)))
                       (combine (mapcar (lambda (x) 
                                 (select x i))
                               desc-multiple-imputed)))
      )))
